import itertools
import yaml
import os

def create_directory(directory_path):
    if not os.path.exists(directory_path):
        os.makedirs(directory_path)
        # print(f"Directory '{directory_path}' created.")
    else:
        print(f"Directory '{directory_path}' already exists.")

model = 'resnet18'
model_dir = f'models_{model}_ks/'
maper_dir = 'mapper/mapper.yaml'
layer_nums = [1,2,7,10,11,14,15,18]
in_dim = '32x32'

shell_file = f"run_resnet18_{in_dim}_ks.sh"
with open(shell_file,'w') as file:
    file.write("#!/bin/bash")
    file.write("\n")

### config 1-2
#layer1 = 8w8a1c1pe_fpadc (1c,2c,fpadc,spadc)
#layers 2-13= 8w8a1c3pe_fpadc (1c,2c,fpadc,spadc)
#layers 14-19= 8w8a1c6pe_fpadc (1c,2c,fpadc,spadc)
#layer 20= 8w8a1c1pe_fpadc (1c,2c,fpadc,spadc)

bits = [1,2]
precisions = ['fpadc']

with open(shell_file,'a+') as file:
    for bit, precision in itertools.product(bits, precisions):
        save_dir = f'outputs/resnet18_{in_dim}_{precision}_{bit}c_ks/'
        for layer in layer_nums:
            dir = save_dir+f'layer{layer}'
            create_directory(dir)
            if layer==1:
                arch = f'8w8a{bit}c7x1pe_{precision}'
                arch_dir = f'{model_dir}{arch}/system_PIM.yaml'
                components_dir=f'{model_dir}{arch}/components/*.yaml'
                constraints_dir = 'constraints/resnet18/constraints_PE7x1.yaml'
                problem_dir = f'layer_shapes/{model}_{in_dim}/layer{layer}.yaml'
                output_dir = save_dir+f'layer{layer}'
                command = f'timeloop-mapper {arch_dir} {components_dir} {maper_dir} {constraints_dir} {problem_dir} -o {output_dir}'
            elif layer==2:
                arch = f'8w8a{bit}c6x1pe_{precision}'
                arch_dir = f'{model_dir}{arch}/system_PIM.yaml'
                components_dir=f'{model_dir}{arch}/components/*.yaml'
                constraints_dir = 'constraints/resnet18/constraints_PE6x1.yaml'
                problem_dir = f'layer_shapes/{model}_{in_dim}/layer{layer}.yaml'
                output_dir = save_dir+f'layer{layer}'
                command = f'timeloop-mapper {arch_dir} {components_dir} {maper_dir} {constraints_dir} {problem_dir} -o {output_dir}'
            elif layer==7:
                arch = f'8w8a{bit}c9x1pe_{precision}'
                arch_dir = f'{model_dir}{arch}/system_PIM.yaml'
                components_dir=f'{model_dir}{arch}/components/*.yaml'
                constraints_dir = 'constraints/resnet18/constraints_PE9x1.yaml'
                problem_dir = f'layer_shapes/{model}_{in_dim}/layer{layer}.yaml'
                output_dir = save_dir+f'layer{layer}'
                command = f'timeloop-mapper {arch_dir} {components_dir} {maper_dir} {constraints_dir} {problem_dir} -o {output_dir}'
            elif layer==10:
                arch = f'8w8a{bit}c9x2pe_{precision}'
                arch_dir = f'{model_dir}{arch}/system_PIM.yaml'
                components_dir=f'{model_dir}{arch}/components/*.yaml'
                constraints_dir = 'constraints/resnet18/constraints_PE9x2.yaml'
                problem_dir = f'layer_shapes/{model}_{in_dim}/layer{layer}.yaml'
                output_dir = save_dir+f'layer{layer}'
                command = f'timeloop-mapper {arch_dir} {components_dir} {maper_dir} {constraints_dir} {problem_dir} -o {output_dir}'
            elif layer==11:
                arch = f'8w8a{bit}c18x2pe_{precision}'
                arch_dir = f'{model_dir}{arch}/system_PIM.yaml'
                components_dir=f'{model_dir}{arch}/components/*.yaml'
                constraints_dir = 'constraints/resnet18/constraints_PE18x2.yaml'
                problem_dir = f'layer_shapes/{model}_{in_dim}/layer{layer}.yaml'
                output_dir = save_dir+f'layer{layer}'
                command = f'timeloop-mapper {arch_dir} {components_dir} {maper_dir} {constraints_dir} {problem_dir} -o {output_dir}'
            elif layer==14:
                arch = f'8w8a{bit}c18x4pe_{precision}'
                arch_dir = f'{model_dir}{arch}/system_PIM.yaml'
                components_dir=f'{model_dir}{arch}/components/*.yaml'
                constraints_dir = 'constraints/resnet18/constraints_PE18x4.yaml'
                problem_dir = f'layer_shapes/{model}_{in_dim}/layer{layer}.yaml'
                output_dir = save_dir+f'layer{layer}'
                command = f'timeloop-mapper {arch_dir} {components_dir} {maper_dir} {constraints_dir} {problem_dir} -o {output_dir}'
            elif layer==15:
                arch = f'8w8a{bit}c36x4pe_{precision}'
                arch_dir = f'{model_dir}{arch}/system_PIM.yaml'
                components_dir=f'{model_dir}{arch}/components/*.yaml'
                constraints_dir = 'constraints/resnet18/constraints_PE36x4.yaml'
                problem_dir = f'layer_shapes/{model}_{in_dim}/layer{layer}.yaml'
                output_dir = save_dir+f'layer{layer}'
                command = f'timeloop-mapper {arch_dir} {components_dir} {maper_dir} {constraints_dir} {problem_dir} -o {output_dir}'
            elif layer==18:
                arch = f'8w8a{bit}c4x2pe_{precision}'
                arch_dir = f'{model_dir}{arch}/system_PIM.yaml'
                components_dir=f'{model_dir}{arch}/components/*.yaml'
                constraints_dir = 'constraints/resnet18/constraints_PE4x2.yaml'
                problem_dir = f'layer_shapes/{model}_{in_dim}/layer{layer}.yaml'
                output_dir = save_dir+f'layer{layer}'
                command = f'timeloop-mapper {arch_dir} {components_dir} {maper_dir} {constraints_dir} {problem_dir} -o {output_dir}'
            file.write(command)
            file.write("\n")
            file.write("echo " + "#"*80)
            file.write("\n")
            file.write(f"echo done {model}_layer{layer}_{in_dim}_{arch}.")
            file.write("\n")
            file.write("echo " + "#"*80)
            file.write("\n")